		              // Inclusion du prototype du PIC 16F
//*************************Ampli_3_Channel*******************************************************************
//************************Programmer: Carl Fortin**************************************************************
//************************Language:Hi tech C 9.83**************************************************************
//PIC16F873A
//Dernire rvision: 3 janvier 2012

#include  <pic.h>
#include  <htc.h>
#include  <math.h>

__CONFIG(WDTE_OFF & FOSC_XT & CP_OFF & LVP_OFF & BOREN_OFF);   //Watchdog disabled,4MHz,Unprotect,Low Voltage Disabled


/*                                 DFINITIONS DES CONSTANTES                                */
/*                                 **************************                                */

#define	_XTAL_FREQ 4000000              // This definition is required to calibrate __delay_us() and __delay_ms()
#define	LED_BICOLOR_PIN_1 RB2           // Led bicolor sur RB2
#define	LED_BICOLOR_PIN_2 RC6           // Led bicolor sur RC0
#define	MUTE_PGA2310 RA1                // MUTE sur PGA2310 actif bas
#define	Cooling_Fan RC7                 // Cooling Fan
#define RST_1 RB4					    //RST_1 on DS1868 1
#define RST_2 RB5					    //RST_2 on DS1868 2
#define STANDBY_1 RB1				    //Standby on LM4782 1
#define STANDBY_2 RB3				    //Standby on LM4782 2
#define VREF 5
#define Line_In_Threshold 50			//Valeur minimum pour arret automatique de l'amplificateur
#define Start_Timer_0 55               // (255-55)* 250 us = 50ms
#define Vol_down 0XC9
#define Vol_up 0X49
#define Power 0XA9
#define Channel_up 0X09
#define Channel_down 0X89
#define Mute 0X29
#define Discrete_off 0X7D
#define Discrete_on 0XC3
#define Volume_Initial 50				//Valeur initial des haut-parleurs en dB
#define Temperature_Max 60
#define Temperature_normal 55
#define C 255 
#define D 227
#define E 204
#define F 191
#define G 170
#define A 153
#define B 136
#define C2 127


#define x 3							//total number of notes in song to be played - modify for specific song
#define y 2							//total number of notes in song to be played - modify for specific song

/*                              DCLARATION DES VARIABLES GLOBALES                           */
/*                              **********************************                           */

bit Bit_pulse                   = 0;
bit false_pulse_detect_bit      = 0;
bit sony_protocol_detect_bit    = 0;
bit Flag_1_Min                  = 0;
bit Amplifier_Status            = 0;		   //Est-ce que l'ampli est allum ou teint
bit Mute_Status                 = 0;		   //Mute inactif au dpart



unsigned char SPI_DATA_IN       = 0;
unsigned char SPI_DATA_OUT      = 0;
unsigned int ValeurAD           = 0;


unsigned int Volume_Mute_Bit    = 1;
unsigned int Volume_Center_Bit  = 0;
unsigned int Volume_Center      = 0;		   //Valeur initial du haut-parleur du centre
unsigned int Volume_Stereo_Bit  = 0;
unsigned int Volume_Stereo      = 0;	  	   //Valeur initial du haut-parleur Stereo

unsigned int Counter_1_Minutes  = 1200;        //1200 x 50ms = 1 minutes
unsigned int IR_code            = 0;
unsigned int Compteur_1         = 0;
unsigned int Pulse_1            = 0;
unsigned int Pulse              = 0;
unsigned char pulse_count       = 0;
unsigned char IR_flag           = 0;
unsigned int pulse1_widht      = 0;
unsigned int pulse2_widht      = 0;
unsigned int pulse3_widht      = 0;
unsigned int pulse4_widht      = 0;
unsigned int pulse5_widht      = 0;
unsigned int pulse6_widht      = 0;
unsigned int pulse7_widht      = 0;
unsigned int pulse8_widht      = 0;
unsigned int pulse9_widht      = 0;
unsigned int pulse10_widht     = 0;
unsigned int pulse11_widht     = 0;
unsigned int pulse12_widht     = 0;

unsigned int song[x]={C, C, C}; //insert notes of song in array
unsigned int song2[y]={C,C};     //insert notes of song in array

unsigned int  Temperature       = 0;



/*                      DCLARATION DES PROTOTYPES DES FONCTIONS INTERNES                    */
/*                      *************************************************                    */


void SET_PWM_Duty(unsigned int Duty);
void Lecture_AD_Temp(void);
void ADC_Init(void);

void _delay(unsigned long cycles);
void Timer0_init(void);
void Init_chip(void);
void Timer_1_Init(void);

void Piezo_Sound_On(void);
void Piezo_Sound_Off(void);
void SPI_Init(void);
void Ampli_Off(void);
void Ampli_On(void);
void Vol_control(void);
void PGA_2310_Init(void);
void Write_SPI_PGA_2310_1 (unsigned int Volume);
void Write_SPI_PGA_2310_2 (unsigned int Volume);
void Auto_shutdown(void);

void Read_IR_Signal(void);
void pulse_widht_listing(void);
void put_sony_pulse_together(void);

/*                               ENTRE DU PROGRAMME PRINCIPAL                               */
/*                               *****************************                               */

void main( )

{                                           //Dbut du programme principale

	Init_chip();
  	SPI_Init();									//Active SPI
    Timer_1_Init();                  		 	//Active Timer 1
    __delay_ms(10);
	ADC_Init();
	Timer0_init();
    Ampli_Off();								//Amplificateur teint au dpart
  
      
		while(1)

		{
          	
            if (Amplifier_Status == 1)

			{
			 Auto_shutdown();
			}

		

			if (IR_flag==1)                   	// Niveau bas dtect sur la PIN RB0 (Capteur infrarouge inverse le signal

			{
           	 IR_flag = 0;						//Remet IR_flag  Zro
			 IR_code = 0;						//Remet IR_code  Zro
		     Read_IR_Signal();					//Dcode le signal Sony

			 GIE = 1;							//Ractive les interruptions globale

             if (sony_protocol_detect_bit == 1) //Si sony protocol est dtect
		     {
			  Vol_control();				    //Controle Ampli
             }

             INTE = 1;  					   //Interrupt on RBO ractiv
		   	} 
			
			

       }

}												//Fin du programme principale



void Read_IR_Signal(void)

{ 
	sony_protocol_detect_bit = 0;
    Pulse_1 = 0;
    Compteur_1 = 0;
    Pulse = 0;
    pulse_count = 0;

    TMR1ON = 0;                                                     //Ferme timer1 et remet a zro
	TMR1L = 0;											            //Timer 1 est remis  zro
	TMR1H = 0;
	TMR1ON = 1;

	while(RB0==0)              			 	                        //Check pour un pulse de 2400 us qui indique une trame Sony
	{
     //Compteur 1 tourne
    }
	    TMR1ON = 0;
		Compteur_1 = (TMR1H<<8)| TMR1L;                            //Determiner la longueur du pulse de START 
        TMR1L = 0;
	    TMR1H = 0;
		TMR1ON = 1;
		
		while(RB0==1 && Pulse_1<1000)              			        //Compte tant que RB0 est haut et que le Pulse ne dpasse pas 1000 us
		{
	     Pulse_1 = (TMR1H<<8)| TMR1L;					        	//Va chercher la valeur du Timer 1 16 Bits pour savoir la longueur du pulse 1
		}
		
		TMR1ON = 0;
		Pulse_1 = (TMR1H<<8)| TMR1L;                                //Determiner la longueur du pulse de START 
        
		

		if(Compteur_1>2300 & Compteur_1<2500 & Pulse_1 < 650)       //Est-ce que le pulse est entre 2300 us et 2500 us pour indiquer le protocol Sony?
		{                                                           //Dbut du protocol Sony dtect
		              
         	int a;
			for (a = 0 ; a < 12 ; a++)   				            //Rpte 12 fois pour dterminer les 12 Bits
            {														//Dbut de la boucle For = 1er bit recu
								                
	            TMR1L = 0;
	            TMR1H = 0;
				TMR1ON = 1;	
				
				while(RB0==0)              			               //Compte tant que RB0 est bas (Dtecteur IR actif bas)
				{
	             //Le timer 1 roule pour savoir la longueur du pulse 1
				}
											
				while(RB0==1 && Pulse<2000)             	       //600 uS (gap entre les bits du protocol SONY) Si le dtecteur revient actif haut il faut sortir
				{
	             Pulse = (TMR1H<<8)| TMR1L;                        //Va chercher la valeur du Timer 1 16 Bits pour savoir la longueur du pulse 2
				}
	            
				TMR1ON = 0;	
	            Pulse = (TMR1H<<8)| TMR1L;              
				        
                pulse_count ++;
				pulse_widht_listing();
 
			}
                                                   //Fin de la boucle For = 12e bit recu
        put_sony_pulse_together();                                  
	    


        }
											         	         
							         	

}							                    	//Fin du Protocol Sony dtect


void put_sony_pulse_together(void)

{

 pulse_count = 0;
 false_pulse_detect_bit = 0;

 int a;

 for (a = 0 ; a < 12 ; a++)

 {

   pulse_count ++;

   switch(pulse_count)

   {

   case 1:
   Pulse = pulse1_widht;
   break;

   case 2:
   Pulse = pulse2_widht;
   break;


   case 3:
   Pulse = pulse3_widht;
   break;

   case 4:
   Pulse = pulse4_widht;
   break;

   case 5:
   Pulse = pulse5_widht;
   break;


   case 6:
   Pulse = pulse6_widht;
   break;

   case 7:
   Pulse = pulse7_widht;
   break;

   case 8:
   Pulse = pulse8_widht;
   break;

   case 9:
   Pulse = pulse9_widht;
   break;

   case 10:
   Pulse = pulse10_widht;
   break;

   case 11:
   Pulse = pulse11_widht;
   break;

   case 12:
   Pulse = 1000;   //Le premier bit LSB du protocol est forc  zro pout viter un erreur car ir dtecteur actif haut
   break;


   }            //Fin switch


	if((Pulse >= 1000)  && ( Pulse  <= 1200 ))      //Si le Pulse 1 et le Pulse 2 ensemble est entre 1100 us et 1300 us le BIT est 0
	{
 	 Bit_pulse = 0;
	}
       
	if((Pulse >= 1600)  && ( Pulse  <= 1800 ))      //Si le Pulse 1 et le Pulse 2 ensemble est entre 1700 us et 1800 us le BIT est 1
    {
     Bit_pulse = 1;
    }
					
	if((Pulse  < 1000) ||  ( Pulse >  1800 ))     	//Si le Pulse 1 et le Pulse 2 ensemble sont plus petit que 1100 us ou plus grand que 1900 us le pulse est null			
	{
	 false_pulse_detect_bit = 1;
	 a = 12;                                         //Skip la dtection des autres bits car un mauvais bit a t dtect
	 IR_code = 255;
    }

	if(false_pulse_detect_bit == 0)
	{
	 IR_code = (IR_code) + (Bit_pulse<<(11-a));          //Place les bits en ordre (le protocol Sony envoie le LSB en premier)
	}



 }      //Fin boucle for

    if(false_pulse_detect_bit == 0)
    {
	 IR_code = IR_code >> 4;	                         //Ramne sur 12 Bits
     sony_protocol_detect_bit = 1;
 	}
				               
}       //Fin fonction put_sony_together

 

void pulse_widht_listing(void)
{
switch(pulse_count)

{
case 1:
pulse1_widht = Pulse;
break;

case 2:
pulse2_widht = Pulse;
break;

case 3:
pulse3_widht = Pulse;
break;

case 4:
pulse4_widht = Pulse;
break;

case 5:
pulse5_widht = Pulse;
break;

case 6:
pulse6_widht = Pulse;

break;

case 7:
pulse7_widht = Pulse;

break;

case 8:
pulse8_widht = Pulse;
break;

case 9:
pulse9_widht = Pulse;
break;

case 10:
pulse10_widht = Pulse;
break;

case 11:
pulse11_widht = Pulse;
break;

case 12:
pulse12_widht = Pulse;
break;
}

}

void Vol_control(void)

{

	switch (IR_code)

	{
	
    case Power:

		
         Amplifier_Status = ~Amplifier_Status;  	// Le statut de l'amplificateur est invers si power est dtect

         if(Amplifier_Status == 1)
		{
	      Ampli_On(); 
		  //Piezo_Sound_On();
		  	  
	    }

    	if(Amplifier_Status == 0)

		{
	     Ampli_Off();
		 //Piezo_Sound_Off();
		}
    __delay_ms(100);       //Dlais qui empeche une touche qui se rpte
	__delay_ms(100);       //Dlais qui empeche une touche qui se rpte

    break;

   case Discrete_off:
   Amplifier_Status = 0;
   Ampli_Off();
   //Piezo_Sound_Off();
   __delay_ms(100);       //Dlais qui empeche une touche qui se rpte
	__delay_ms(100);       //Dlais qui empeche une touche qui se rpte
   break;

  case Discrete_on:
   Amplifier_Status = 1;
   Ampli_On();
   //Piezo_Sound_On();
    __delay_ms(100);       //Dlais qui empeche une touche qui se rpte
	__delay_ms(100);       //Dlais qui empeche une touche qui se rpte
   break;


    }

    if(Amplifier_Status == 1) 
 
    {

	 switch (IR_code)

	{
    case Channel_up:
	
	    if (Volume_Stereo <= 99 && Mute_Status == 0)
	  
		{
		Volume_Stereo ++;
		Volume_Stereo_Bit = ((Volume_Stereo*255)/100);   //Transforme volume de 0  100 en 256 bit
        Write_SPI_PGA_2310_1 (Volume_Stereo_Bit);
        }
	
	break;

	case Channel_down:
		if (Volume_Stereo > 0 && Mute_Status == 0)
		{
		Volume_Stereo --;
		Volume_Stereo_Bit = ((Volume_Stereo*255)/100);   //Transforme volume de 0  100 en 256 bit
        Write_SPI_PGA_2310_1 (Volume_Stereo_Bit);
	    }
    	

	break;

    case Vol_up:

		if (Volume_Center <= 99 && Mute_Status == 0)
		{
		Volume_Center ++;
		Volume_Center_Bit = ((Volume_Center*255)/100);
        Write_SPI_PGA_2310_2 (Volume_Center_Bit);
	    }
	      	   
	break;


    case Vol_down:

     	if (Volume_Center > 0 && Mute_Status == 0)
		{
        Volume_Center --;
		Volume_Center_Bit = ((Volume_Center*255)/100);
		Write_SPI_PGA_2310_2 (Volume_Center_Bit);
	    }
   break;

   case Mute:

   Mute_Status = ~Mute_Status;
   
       if (Mute_Status == 1)
	   {

        MUTE_PGA2310 = 0;

       }

       if (Mute_Status == 0)
	   {
        
        MUTE_PGA2310 = 1;

	   }
	          
	__delay_ms(100);       //Dlais qui empeche une touche qui se rpte
	__delay_ms(100);       //Dlais qui empeche une touche qui se rpte
	__delay_ms(100);       //Dlais qui empeche une touche qui se rpte
	
	
	break;
	
	  }
	
	}
	

	}

														//Fin de la fonction Read_IR_Signal

void Write_SPI_PGA_2310_1 (unsigned int Volume)

{
 


  RST_1 = 0;   							  //CS1 pin Low on PGA_2310 (Dbut du transfert)
  __delay_ms(5);
  SSPBUF=Volume_Stereo_Bit;				  //SPI_DATA_OUT est plac dans le registre SSPBUF
  while(!SSPIF);						  //Quand SSPIF passe  1, transmission de donne termine
  SSPIF=0;								  //On passe SSPIF  0 , et on peut envoyer une autre donne
  SPI_DATA_IN = SSPBUF;                   //Lecture de SDI (Rponse)

  SSPBUF=Volume_Stereo_Bit;						  
  while(!SSPIF);							
  SSPIF=0;		                          
  SPI_DATA_IN = SSPBUF;                   
  
  RST_1 = 1;							  //CS1 pin High on PGA_2310 (Fin du transfert)
  __delay_ms(5);
  
}


void Write_SPI_PGA_2310_2 (unsigned int Volume)

{

  
  RST_2 = 0;   							  //CS1 pin Low on PGA_2310 (Dbut du transfert)
  __delay_ms(5);
  SSPBUF=Volume_Center_Bit;				  //SPI_DATA_OUT est plac dans le registre SSPBUF
  while(!SSPIF);						  //Quand SSPIF passe  1, transmission de donne termine
  SSPIF=0;								  //On passe SSPIF  0 , et on peut envoyer une autre donne
  SPI_DATA_IN = SSPBUF;                   //Lecture de SDI (Rponse)

  SSPBUF=Volume_Center_Bit;						  
  while(!SSPIF);							
  SSPIF=0;		                          
  SPI_DATA_IN = SSPBUF;                   
  
  RST_2 = 1;							  //CS1 pin High on PGA_2310 (Fin du transfert)
  __delay_ms(5);
  
}







void PGA_2310_Init(void)

{
    
    Volume_Stereo_Bit = 1;      //((Volume_Initial*255)/100);   //Transforme volume de 0  100 en 256 bit
	Write_SPI_PGA_2310_1 (Volume_Stereo_Bit);				    //Valeur initial Pot digital streo	
	
    Volume_Center_Bit = ((Volume_Initial*255)/100);   //Transforme volume de 0  100 en 256 bit
    Write_SPI_PGA_2310_2 (Volume_Center_Bit);

	Volume_Stereo = 10;
  	Volume_Center = Volume_Initial;

	
}
       

void SET_PWM_Duty (unsigned int Duty)

{

unsigned int CCP1CON_LSB = 0;
unsigned int CCPR1L_MSB = 0;

//PR2 = 249;                                     //[(PR2) + 1]  4  TOSC (TMR2 prescale value) = [(249) + 1]  4  250ns (4) = 1ms (1 KHz)
//Duty = Duty *10;                              //50 * 10 = 500 us (1 ms /2)
CCPR1L_MSB = Duty >> 2;                       //Enlve les 2 derniers bits pour obtenir 8 bits
CCP1CON_LSB = Duty  & 0b0000000011;           //Garde les 2 derniers bit
CCP1CON_LSB = CCP1CON_LSB << 5;               //Shift les bits pour les ramener au bit 4 et 5 du registre
CCP1CON_LSB = CCP1CON_LSB + 0b00001100;       //Bit 5 et 6 LSB + PWM MODE OPERATION

CCPR1L = CCPR1L_MSB;                          // 50% duty cycle (50% de 1 Khz = 500 uS) 500 uS/(250nsx4)=500
CCP1CON = CCP1CON_LSB;                        //Bit 5 et 6 LSB + PWM MODE OPERATION
RC2 = 0;                                      //Output PWM on RC2 PIN 13
//T2CON = 0b00000101;                          //PRESCALER OF 4 Timer 2 is On

}


void Lecture_AD_Temp (void)

{                                                 //Dbut de la fonction lecture temprature
   ADCON0 =  0b01011001;                          //Channel 3 RA3 pour lire temp du LM35
   ADCON1  = 0b10000000;                          //All channel analog
   ADON   = 1;                                    // Convertisseur est activ
   __delay_us(20);                                //(charge du condensateur)
   GO = 1;                                      // Dmarre la conversion

   while (GO == 1)                              // On boucle tant que le GO/DONE bit n'est pas a zro pour indiquer une fin de conversion
   {
     // Fait rien
   }
   ValeurAD = ADRESH;                             //La valeur gale le resultat dans registre ADRESH(8 bits)
   ValeurAD = ValeurAD<<8;
   ValeurAD = ValeurAD | ADRESL;                  //Me permet d'aller lire une petite valeur dans le registre
   ADON   = 0;                                    //Convertisseur est dsactiv

   Temperature = (ValeurAD*VREF);           //Conversion de bit  voltage
   Temperature = (Temperature/10);          //Conversion de voltage  Temperature

   
        if (Temperature > Temperature_Max)
   		{
   		Ampli_Off();
  	    Piezo_Sound_Off();
   		}

ADCON1  = 0b10001110;                             //Remet RA1 en digital pour le mute et RA0 pour le line_sense en analog
   
   

}

void ADC_Init(void)
{

/*                       Initialisation du convertisseur analogique-numrique                */

ADCON0 = 0b01000001;        
         //01------         FOSC/8 ce qui donne un temps d'aquisition de 2 uS (4MHz/8)
         //--000---         Canal 0 RA0 pin 2 AN0 (CHS = 000)  
         //-------1         Turn ADC on (ADON = 1)

ADCON1  = 0b10001110;
          //1-------        Right justified. (ADFM = 1) 
          //----1110        A/D Port Configuration RA1-RA5 Digital RA0 Analog VREF+ = VDD and VREF- = VSS 

}


void Piezo_Sound_On(void)
{
SET_PWM_Duty(50);
unsigned int i;
for (i=0; i<y; i++)
	  {                          //play x notes inside song array
      
      PR2 = song2[i];
	  T2CON = 0b00000101;        //PRESCALER OF 4 Timer 2 is On 
                                 //set PWM frequency according to entries in song array
      __delay_ms(100);           //each note is played for 400ms*relative length
	  __delay_ms(100); 
      __delay_ms(100); 
      __delay_ms(100); 
        
   
      PR2 = 1;                   //the PWM frequency set beyond audible range in order to create a short silence between notes
                               
      __delay_ms(50);            //the silence is played for 50 ms                  
      }
	  T2CON = 0b00000001;        //PRESCALER OF 4 Timer 2 is OFF
	  CCP1CON = 0;			     //force the RC2/CCP1 compare output latch to the default low level.
	  RC2 = 0;
}

void Piezo_Sound_Off(void)
{
SET_PWM_Duty(50);
unsigned int i;
for (i=0; i<x; i++)
	  {                          //play x notes inside song array
      
      PR2 = song[i];
	  T2CON = 0b00000101;        //PRESCALER OF 4 Timer 2 is On 
                                 //set PWM frequency according to entries in song array
      __delay_ms(100);           //each note is played for 400ms*relative length
	  __delay_ms(100); 
      __delay_ms(100); 
      __delay_ms(100); 
        
   
      PR2 = 1;                   //the PWM frequency set beyond audible range in order to create a short silence between notes
                               
      __delay_ms(50);            //the silence is played for 50 ms                  
      }
	  T2CON = 0b00000001;        //PRESCALER OF 4 Timer 2 is OFF
	  CCP1CON = 0;			     //force the RC2/CCP1 compare output latch to the default low level.
	  RC2 = 0;
}

void Ampli_Off(void)

{

STANDBY_1 = 1;                    //teint Ampli stro LM4782
STANDBY_2 = 1;		              //teint Ampli centre LM4782

PGA_2310_Init();

LED_BICOLOR_PIN_1 = 1;
LED_BICOLOR_PIN_2 = 0;
Cooling_Fan = 0;
T0IE   = 0;                      //Interruption du timer 0 non permise
T0IF   = 0;

}


void Ampli_On(void)

{

STANDBY_1 = 0;  	//Allume Ampli stro LM4782
STANDBY_2 = 0;		//Allume Ampli centre LM4782
LED_BICOLOR_PIN_1 = 0;
LED_BICOLOR_PIN_2 = 1;
MUTE_PGA2310 = 1;

Flag_1_Min = 0;
TMR0 = Start_Timer_0;
Counter_1_Minutes = 1200;  //Remise a zro du compteur 1 minutes pour le check de temprature
T0IE   = 1;               //Interruption du timer permise


}

void Auto_shutdown(void)

{

	if (Flag_1_Min==1) //1 minute s'est coul on check la temprature interne.
			{
			Flag_1_Min = 0;
			Lecture_AD_Temp(); //Ferme l'amplificateur si la temprature est trop haute
			
			if (Temperature>Temperature_normal)
			{
			Cooling_Fan = 1;
			}
			else
			{
			Cooling_Fan = 0;
			}
			}

}

void SPI_Init (void)

{

SSPSTAT = 0b01000000;                          //SYNC SERIAL PORT STATUS REGISTER 
          //0-------                           Input data sampled at middle of data output time (SMP)
		  //-1------						   Data transmitted on rising edge of SCK (CKE)
		  //-------0						   Buffer Full Status bit (BF)
		  
SSPCON  = 0b00100000;						   //SYNC SERIAL PORT CONTROL REGISTER
 		  //0-------                           Write Collision Detect bit     (0 = No collision)
          //-0------                           Receive Overflow Indicator bit (0 = No collision)
		  //--1-----						   Enables serial port and configures SCK, SDO, SDI, and SS as the source of the serial port pins (SSPEN)
		  //---0----						   Clock Polarity Select bit (0 = Idle state for clock is a low level)
		  //----0000						   SPI Master mode, clock = FOSC/4 (Clock = 1 MHz) 
}

void Timer_1_Init (void)

 {

 T1CON = 0b00001100;          //Enables Timer1, Internal clock (FOSC/4) ,1:1 Prescale value 1uS
         //--00----           T1CKPS1:T1CKPS0: Timer1 Input Clock Prescale Select bits
	     //----1---   	      T1OSCEN: Timer1 Oscillator Enable Control bit
	     //-----1--    		  T1SYNC: Timer1 External Clock Input Synchronization Control bit
	     //------0-  	      TMR1CS: Timer1 Clock Source Select bit
	     //-------0   		  TMR1ON: Timer1 On bit
	    

 __delay_ms(1);               //Attend que l'oscillateur se stabilise
 
 
 }

void Timer0_init (void)

{
/*                                    Initialisation du timer0                                */


nRBPU = 1;
INTEDG = 0;                  //Interrupt on the falling edge
T0CS   = 0;                  //Timer0 aliment par clock interne
PSA    = 0;                  //Le prescaler est pour le timer0
PS0    = 1;                 //(Fosc / 4) = 1 Mhz Divis par 256 pour une frquence de 4KHz = 250 Us par coup de clock
PS1    = 1;
PS2    = 1;
T0IE   = 0;                 //Interruption non permise au dpart
T0IF   = 0;
TMR0 = Start_Timer_0;        //Commence a compter a 55

}

void interrupt routine (void)

{

  if(T0IF == 1)
   {
    T0IF=0;                     //Remise  0 du flag
    TMR0 = Start_Timer_0;
    Counter_1_Minutes --;
   }

     
      
   if(Counter_1_Minutes == 0)       //Si 1 min est arriv
   {
    Counter_1_Minutes = 1200;        //Remise  1200 du compteur logiciel de 1 Min (1200X50ms)
    Flag_1_Min = 1;
   }
   
   
   if(INTF == 1)                //Interruption externe sur RB0 actif bas
   
   {
   
    GIE = 0;                    //Dsactive toute interruption
	INTE = 0;                   //Dsactive Interrupttion externe sur RBO temporairement
    INTF = 0;   				// Clear Flag RB0
    IR_flag = 1;
	
   }
   
   
}


void Init_chip (void)

{

/*                                 GESTIONS DES INTERRUPTIONS                                */
/*                                 **************************                                */

OPTION_REG = 0b00000000;  //TMR0  prescaler/WDT  postscaler 
         //0-------   RBPU: PORTB Pull-up Enable bit
	     //-0------	  INTEDG: Interrupt Edge Select bit
	     //--0-----   T0CS: TMR0 Clock Source Select bit
	     //---0----   T0SE: TMR0 Source Edge Select bit
	     //----0---   PSA: Prescaler Assignment bit
	     //-----000   PS2:PS0: Prescaler Rate Select bits    

INTCON = 0b11010000;  //Register is a readable and writable register, which contains various enable and flag bits
         //1-------   GIE: Global Interrupt Enable bit 
	     //-1------	  PEIE: Peripheral Interrupt Enable bit
	     //--0-----   T0IE: TMR0 Overflow Interrupt Enable bit
	     //---1----   INTE: RB0/INT External Interrupt Enable bit
	     //----0---   RBIE: RB Port Change Interrupt Enable bit 
	     //-----0--   T0IF: TMR0 Overflow Interrupt Flag bit
	     //------0-   INTF: RB0/INT External Interrupt Flag bit
	     //-------0   RBIF: RB Port Change Interrupt Flag bit 

PIE1 = 0b00000000;   //The PIE1 register contains the individual enable bits for the peripheral interrupts.
       //0-------    PSPIE(1): Parallel Slave Port Read/Write Interrupt Enable bit
	   //-0------	 ADIE:     A/D Converter Interrupt Enable bit
	   //--0-----    RCIE:     USART Receive Interrupt Enable bit
	   //---0----    TXIE:     USART Transmit Interrupt Enable bit
	   //----0---    SSPIE:    Synchronous Serial Port Interrupt Enable bit
	   //-----0--    CCP1IE:   CCP1 Interrupt Enable bit
	   //------0-    TMR2IE:   TMR2 to PR2 Match Interrupt Enable bit
	   //-------0    TMR1IE:   TMR1 Overflow Interrupt Enable bit
	   
	   
PIE2 = 0b00000000;   //Individual enable bits for the  CCP2  peripheral  interrupt
       //-0------	  Reserved Always maintain this bit clear
	   //---0----     EEPROM Write Operation Interrupt Enable
	   //----0---     BCLIE:  Bus Collision Interrupt Enable
	   //-------0     CCP2IE: CCP2 Interrupt Enable bit
	   	   
PIR1 = 0b00000000;   //Individual flag bits for the peripheral interrupts.
       //0-------    PSPIF:  Parallel Slave Port Read/Write Interrupt Flag bit
	   //-0------	 ADIF:   A/D Converter Interrupt Flag bit
	   //--0-----    RCIF:   USART Receive Interrupt Flag bit
	   //---0----    TXIF:   USART Transmit Interrupt Flag bit
	   //----0---    SSPIF:  Synchronous Serial Port (SSP) Interrupt Flag
	   //-----0--    CCP1IF: CCP1 Interrupt Flag bit
	   //------0-    TMR2IF: TMR2 to PR2 Match Interrupt Flag bit
	   //-------0    TMR1IF: TMR1 Overflow Interrupt Flag bit

/*                                 GESTIONS DES PORTS                                        */
/*                                 **************************                                */

TRISA = 0b11111101;	     // Tous les bits en entre sauf RA1 pour Mute du PGA2310
TRISB = 0b00000001;	     // Port B en sortie sauf RBO pour Intterupt
TRISC = 0b00010000;	     // Tout en sortie,RC4 en entre pour SDI,RC5 en sortie pour SDO,RC3 en sortie pour clock
							   
PORTA = 0;				 //Tout est  zro en partant
PORTB = 0;				
PORTC = 0;

RST_1 = 1;               //CS high on PGA_2310_1
RST_2 = 1;				 //CS high on PGA_2310_2
MUTE_PGA2310 = 1;


}